
"use strict"; 

const body = document.body;
const bgColorsBody = ["#286CD6", "#8f00ff", "#e75480", "#161617cc", "#f45a2a"];
const menu = body.querySelector(".inc-admin-menu");
const menuItems = menu.querySelectorAll(".inc-admin-menu__item");
const menuBorder = menu.querySelector(".inc-admin-menu__border");
let activeItem = menu.querySelector(".active");

function incClickItem(item, index) {

    menu.style.removeProperty("--timeOut");
    
    if (activeItem == item) return;
    
    if (activeItem) {
        activeItem.classList.remove("active");
    }

    
    item.classList.add("active");
    menu.style.backgroundColor = bgColorsBody[index];
	menuBorder.style.backgroundColor = bgColorsBody[index];
    activeItem = item;
    incOffsetMenuBorder(activeItem, menuBorder);
    
    
}

function incOffsetMenuBorder(element, menuBorder) {

    const offsetActiveItem = element.getBoundingClientRect();
	const left = Math.floor( ( element.offsetLeft + ( element.offsetWidth / 2 ) ) - ( menuBorder.offsetWidth / 2 ) ) +  "px";
	
    menuBorder.style.transform = `translate3d(${left}, 0 , 0)`;

}

incOffsetMenuBorder(activeItem, menuBorder);

menuItems.forEach((item, index) => {

    item.addEventListener("click", () => incClickItem(item, index));
    
})

window.addEventListener("resize", () => {
    incOffsetMenuBorder(activeItem, menuBorder);
    menu.style.setProperty("--timeOut", "none");
});